# Vespucci 10.1 Highlights
 
2018-02-22
 
## Under the hood

This release is mainly a clean up release with no major new functionality, but inclusion of projects that were started a while back and some general improvements. There have been some modest performance improvements in both data rendering and with respect to tile retrieval and rendering.

## GPX Waypoints
 
An imported GPX track can now include GPX way points. These can be selected and converted in to OSM Nodes either via manual selection of a preset, or via an automatic search of the term in the GPX "type" fields in the presets.

## Imagery database, custom imagery, OAM and MBTiles

As you may know we use the [Editor Layer Index](https://github.com/osmlab/editor-layer-index) for our background and overlay imagery configuration. Previously we re-read and re-parsed the configuration file on every start of vespucci, we now store the configuration in a database on initial start up and after upgrades. This improves start up time considerably. We've further added a method to download updated configuration directly from the Editor Layer Index site (not available on older Android devices).

Storing this information in a database was a prerequisite to creating a simple UI to allow custom imagery to be added (there is still a facility to include imagery configuration via a file). While we were at it, we've added support for layers in MBTile format for enhanced offline editing.

More information on the topic can be found on [vespucci.io](http://vespucci.io/tutorials/custom_imagery/).

### WMS server support

10.1 adds limited support for WMS servers that support "web-mercator" projection (EPSG:3857 or EPSG:900913). The requested tiles are 512px x 512px in size to reduce the load on the target servers a bit, still this should likely be used with restraint.

### OAM Support

Layers provided via OAM can be added to the imagery configuration via a query to the OAM catalog (this currently doesn't work for devices running older Android versions as OAM doesn't support TLS 1.0).

### MBTiles

MBTile files containing jpeg or png imagery can now be used as custom imagery sources on device.

### Imagery offsets

The way how we handle local offsets (contrary to such stored in the [imagery offset database](http://offsets.textual.ru/)) has changed. While 
these were always a bit persistent, it wasn't really clear when and how they would be re-applied or vanish. We now store per adjusted layer one set of offsets permanently, if the app is started with a view near (100m) the location of such an adjustment it will be automatically applied and a warning displayed, the same on background layer changes. This results in non-surprising behaviour: app restarts and pausing in the same location will not suddenly change imagery alignment, but doing so further away from the location will show the layer as is.

This is not intended to be a replacement for storing offsets in and retrieving them from the imagery offset database that allows a far finer degree of control.

## Geo-location sensitive validation

We've done some initial work on providing support for location sensitive validation, currently this is limited to missing "mph" units in speed tags in countries that use such units.

## Miscellaneous 

* In many situations when an empty relation can be created a dialog is shown asking how to proceed.
* In high density areas node touch halos will be reduced as you zoom out.
* On tablets running Android 7 or higher, sub-menus are not visible due to an Android/support library bug. As a workaround we are providing a menu layout for such devices that doesn't use sub-menus, the layout however is not reflected in the documentation.  

The full change log is available [here](https://github.com/MarcusWolschon/osmeditor4android/commits/master)


# Upgrading from previous versions

* The saved editing state file format has changed, please complete any edits before upgrading.

* Custom imagery files now need to follow the new geojson format and be named _imagery.geojson_ .

# Known problems

* For known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)

